using System;
using Server;
using Server.Items;
using Server.Mobiles;
using System.Collections;

/*
** XmlQuestPointsRewards
** ArteGordon
** updated 9/18/05
**
** this class lets you specify rewards that can be purchased for XmlQuestPoints quest Credits.
** The items will be displayed in the QuestPointsRewardGump that is opened by the QuestPointsRewardStone
*/

namespace Server.Engines.XmlSpawner2
{
    public class XmlQuestPointsRewards
    {
        public int Cost;       // cost of the reward in credits
        public Type  RewardType;   // this will be used to create an instance of the reward
        public string Name;         // used to describe the reward in the gump
        public int ItemID;     // used for display purposes
        public object [] RewardArgs; // arguments passed to the reward constructor
        public int MinPoints;   // the minimum points requirement for the reward

        private static ArrayList    PointsRewardList = new ArrayList();
        
        public static ArrayList RewardsList { get { return PointsRewardList; } }
        
        public XmlQuestPointsRewards(int minpoints, Type reward, string name, int cost, int id, object[] args)
        {
            RewardType = reward;
            Cost = cost;
            ItemID = id;
            Name = name;
            RewardArgs = args;
            MinPoints = minpoints;
        }
        
        public static void Initialize()
        {
            // these are items as rewards. Note that the args list must match a constructor for the reward type specified.
//             PointsRewardList.Add( new XmlQuestPointsRewards( 1000, typeof(PowerScroll), "105 Smithing powerscroll", 1000, 0x14F0, new object[] { SkillName.Blacksmith, 105 }));
//             PointsRewardList.Add( new XmlQuestPointsRewards( 2000, typeof(PowerScroll), "110 Smithing powerscroll", 2000, 0x14F0, new object[] { SkillName.Blacksmith, 110 }));
//             PointsRewardList.Add( new XmlQuestPointsRewards( 4000, typeof(PowerScroll), "115 Smithing powerscroll", 4000, 0x14F0, new object[] { SkillName.Blacksmith, 115 }));
//             PointsRewardList.Add( new XmlQuestPointsRewards( 500, typeof(AncientSmithyHammer), "+20 Ancient Smithy Hammer, 50 uses", 500, 0x13E4, new object[] { 20, 50 }));
//             PointsRewardList.Add( new XmlQuestPointsRewards( 200, typeof(ColoredAnvil), "Colored Anvil", 400, 0xFAF, null ));
//             PointsRewardList.Add( new XmlQuestPointsRewards( 100, typeof(PowderOfTemperament), "Powder Of Temperament, 10 uses", 300, 4102, new object[] { 10 }));
//             PointsRewardList.Add( new XmlQuestPointsRewards( 100, typeof(LeatherGlovesOfMining), "+20 Leather Gloves Of Mining", 200, 0x13c6, new object[] { 20 }));

            // this is an example of adding a mobile as a reward
//             PointsRewardList.Add( new XmlQuestPointsRewards( 0, typeof(RidableLlama),"Ridable Llama", 1, 0x20f6, null));

            PointsRewardList.Add( new XmlQuestPointsRewards( 250, typeof(StatScroll), "Stat Scroll +1", 100, 5360, new object[] { 1 }));
            PointsRewardList.Add( new XmlQuestPointsRewards( 250, typeof(RandomLevelClothingBag), "Random level clothing bag", 100, 3702, new object[] { 1 } ));
            PointsRewardList.Add( new XmlQuestPointsRewards( 250, typeof(ExaltedLevelUpScroll), "+10 scroll of Leveling", 100, 5360, null ));
            PointsRewardList.Add( new XmlQuestPointsRewards( 250, typeof(SlzaAuberonu), "Slza auberonu", 100, 12629, null ));
            PointsRewardList.Add( new XmlQuestPointsRewards( 250, typeof(MagicScroll), "Magic Scroll +1", 100, 5360, new object[] { 1 }));
            PointsRewardList.Add( new XmlQuestPointsRewards( 200, typeof(MagicalWire), "Magical Wire +1", 70, 6263, new object[] { 1 }));
            PointsRewardList.Add( new XmlQuestPointsRewards( 200, typeof(MesicniKamen), "Mesicni kamen", 70, 3979, new object[] { 1 }));
            
            // this is an example of adding an attachment as a reward
            PointsRewardList.Add( new XmlQuestPointsRewards( 100, typeof(XmlLightning), "Lightning damage bonus for 1 day", 30, 0, new object[] { 100, 10.0, 1440.0 }));
            
            // PointsRewardList.Add( new XmlQuestPointsRewards( 50, typeof(XmlStr), "+20 Strength for 1 day", 20, 0, new object[] { 20, 86400.0 }));
            // PointsRewardList.Add( new XmlQuestPointsRewards( 50, typeof(XmlDex), "+20 Dexterity for 1 day", 20, 0, new object[] { 20, 86400.0 }));
            // PointsRewardList.Add( new XmlQuestPointsRewards( 50, typeof(XmlInt), "+20 Inteligence for 1 day", 20, 0, new object[] { 20, 86400.0 }));
            
            PointsRewardList.Add( new XmlQuestPointsRewards( 0, typeof(XmlEnemyMastery), "+200% Dragon Mastery for 1 day", 15, 0, new object[] { "Dragon", 30, 200, 1440.0 }));
            PointsRewardList.Add( new XmlQuestPointsRewards( 0, typeof(XmlEnemyMastery), "+200% Balron Mastery for 1 day", 15, 0, new object[] { "Balron", 30, 200, 1440.0 }));
            PointsRewardList.Add( new XmlQuestPointsRewards( 0, typeof(XmlEnemyMastery), "+200% Bone Warrior Mastery for 1 day", 15, 0, new object[] { "BoneWarrior", 30, 200, 1440.0 }));
            PointsRewardList.Add( new XmlQuestPointsRewards( 0, typeof(XmlEnemyMastery), "+200% Evil Mage Lord Mastery for 1 day", 15, 0, new object[] { "EvilMageLord", 30, 200, 1440.0 }));
            PointsRewardList.Add( new XmlQuestPointsRewards( 0, typeof(XmlEnemyMastery), "+200% Ogre Lord Mastery for 1 day", 15, 0, new object[] { "OgreLord", 30, 200, 1440.0 }));
            PointsRewardList.Add( new XmlQuestPointsRewards( 0, typeof(XmlEnemyMastery), "+200% Murderer Mastery for 1 day", 15, 0, new object[] { "Murderer", 30, 200, 1440.0 }));
            PointsRewardList.Add( new XmlQuestPointsRewards( 0, typeof(XmlEnemyMastery), "+200% Goblin Warrior Mastery for 1 day", 15, 0, new object[] { "GoblinWarrior", 30, 200, 1440.0 }));
            PointsRewardList.Add( new XmlQuestPointsRewards( 0, typeof(XmlEnemyMastery), "+200% Spider King Mastery for 1 day", 15, 0, new object[] { "SpiderKing", 30, 200, 1440.0 }));
            PointsRewardList.Add( new XmlQuestPointsRewards( 0, typeof(XmlEnemyMastery), "+200% Beholder Mastery for 1 day", 15, 0, new object[] { "Beholder", 30, 200, 1440.0 }));
            PointsRewardList.Add( new XmlQuestPointsRewards( 0, typeof(XmlEnemyMastery), "+200% Ancient Wyrm Mastery for 1 day", 15, 0, new object[] { "AncientWyrm", 30, 200, 1440.0 }));
            PointsRewardList.Add( new XmlQuestPointsRewards( 0, typeof(XmlEnemyMastery), "+200% Kraken Mastery for 1 day", 15, 0, new object[] { "Kraken", 30, 200, 1440.0 }));
            PointsRewardList.Add( new XmlQuestPointsRewards( 0, typeof(XmlEnemyMastery), "+200% Fan Dancer Mastery for 1 day", 15, 0, new object[] { "FanDancer", 30, 200, 1440.0 }));
        }

    }
}
